local crushing_lib = require("prototypes.libraries.crushing")

crushing_lib.make_recipe(data.raw.item["bulk-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
    { type = "item", name = "kr-electronic-components", amount = 2 },
  },
})

crushing_lib.make_recipe(data.raw.item["burner-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
  },
})

crushing_lib.make_recipe(data.raw.item["fast-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
  },
})

crushing_lib.make_recipe(data.raw.item["inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
  },
})

crushing_lib.make_recipe(data.raw.item["long-handed-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
  },
})

crushing_lib.make_recipe(data.raw.item["kr-superior-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
    { type = "item", name = "kr-electronic-components", amount = 4 },
    { type = "item", name = "kr-imersite-powder", amount = 3 },
  },
})

crushing_lib.make_recipe(data.raw.item["kr-superior-long-inserter"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-inserter-parts", amount = 1 },
    { type = "item", name = "kr-electronic-components", amount = 4 },
    { type = "item", name = "kr-imersite-powder", amount = 6 },
  },
})

crushing_lib.make_recipe(data.raw.item["kr-imersite-crystal"], {
  subgroup = "intermediate-product",
  order = "e[ei-electronic-components]",
  energy_required = 1,
  results = {
    { type = "item", name = "kr-imersite-powder", amount = 3 },
  },
})

data:extend({
  {
    type = "recipe",
    name = "kr-imersite-powder",
    icon = "__Krastorio2Assets__/icons/items/imersite-powder.png",
    enabled = false,
    category = "kr-crushing",
    energy_required = 3,
    ingredients = {
      { type = "item", name = "kr-imersite", amount = 3 },
    },
    results = {
      { type = "item", name = "kr-imersite-powder", amount = 3 },
      { type = "item", name = "kr-sand", amount = 3 },
    },
    main_product = "kr-imersite-powder",
    allow_productivity = true,
  },
  {
    type = "recipe",
    name = "kr-sand",
    enabled = false,
    category = "kr-crushing",
    energy_required = 1,
    ingredients = {
      { type = "item", name = "stone", amount = 3 },
    },
    results = {
      { type = "item", name = "kr-sand", amount_min = 7, amount_max = 8 },
    },
    allow_productivity = true,
  },
})
