if not mods["Dectorio"] then
  return
end

local jackhammer = data.raw["selection-tool"]["kr-jackhammer"]

local tile_filters = jackhammer.select.tile_filters
assert(tile_filters, "Jackhammer tile_filters is nil")
local alt_tile_filters = jackhammer.alt_select.tile_filters
assert(alt_tile_filters, "Jackhammer alt_tile_filters is nil")

--- @param tile_name data.TileID
local function add_tile(tile_name)
  table.insert(tile_filters, tile_name)
  table.insert(alt_tile_filters, tile_name)
end

local literal_tile_names = {
  "dect-concrete-grid",
  "dect-wood-floor",
}

for _, tile_name in pairs(literal_tile_names) do
  if data.raw.tile[tile_name] then
    add_tile(tile_name)
  end
end

local tile_patterns = {
  "^dect%-.-%-gravel$",
  "^dect%-paint%-.-$",
}

for tile_name in pairs(data.raw.tile) do
  for _, pattern in pairs(tile_patterns) do
    if string.find(tile_name, pattern) then
      add_tile(tile_name)
    end
  end
end

local dectorio_stack_size = settings.startup["dectorio-flooring-stack-size"].value --[[@as int]]

data.raw.item["concrete"].stack_size = dectorio_stack_size
data.raw.item["hazard-concrete"].stack_size = dectorio_stack_size
data.raw.item["kr-black-reinforced-plate"].stack_size = dectorio_stack_size
data.raw.item["kr-white-reinforced-plate"].stack_size = dectorio_stack_size
data.raw.item["landfill"].stack_size = dectorio_stack_size
data.raw.item["refined-concrete"].stack_size = dectorio_stack_size
data.raw.item["refined-hazard-concrete"].stack_size = dectorio_stack_size
data.raw.item["stone-brick"].stack_size = dectorio_stack_size
