local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

data:extend({
  {
    type = "recipe",
    name = "kr-matter-associator",
    energy_required = 30,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-imersium-beam", amount = 4 },
      { type = "item", name = "kr-steel-pipe", amount = 4 },
      { type = "item", name = "kr-energy-control-unit", amount = 10 },
      { type = "item", name = "kr-ai-core", amount = 3 },
    },
    results = { { type = "item", name = "kr-matter-associator", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-matter-associator",
    icon = "__Krastorio2Assets__/icons/entities/matter-associator.png",
    subgroup = "production-machine",
    order = "i[matter]-b[matter-associator]",
    place_result = "kr-matter-associator",
    stack_size = 25,
  },
  {
    type = "assembling-machine",
    name = "kr-matter-associator",
    icon = "__Krastorio2Assets__/icons/entities/matter-associator.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 1, result = "kr-matter-associator" },
    collision_box = { { -3.25, -3.25 }, { 3.25, 3.25 } },
    selection_box = { { -3.5, -3.5 }, { 3.5, 3.5 } },
    fast_replaceable_group = "assembling-machine",
    max_health = 2000,
    corpse = "kr-medium-random-pipes-remnants",
    dying_explosion = "kr-medium-matter-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 70 },
      { type = "impact", percent = 70 },
    },
    crafting_categories = { "kr-matter-deconversion" },
    crafting_speed = 1.0,
    ingredient_count = 6,
    module_slots = 4,
    allowed_effects = { "consumption", "productivity", "speed", "pollution" },
    fluid_boxes = {
      {
        production_type = "input",
        pipe_picture = require("prototypes.buildings.pipe-picture"),
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { 0, -3 } } },
      },
      {
        production_type = "output",
        pipe_picture = require("prototypes.buildings.pipe-picture"),
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.west, position = { -3, 0 } } },
      },
      {
        production_type = "output",
        pipe_picture = require("prototypes.buildings.pipe-picture"),
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.east, position = { 3, 0 } } },
      },
      {
        production_type = "output",
        pipe_picture = require("prototypes.buildings.pipe-picture"),
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { 0, 3 } } },
      },
    },
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 50 },
    },
    energy_usage = "48.39MW",
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = {
        filename = "__Krastorio2Assets__/sounds/buildings/matter-associator.ogg",
        volume = 0.60,
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg" },
    },
    graphics_set = {
      animation = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator.png",
            priority = "high",
            width = 473,
            height = 489,
            frame_count = 1,
            scale = 0.5,
            shift = { 0, -0.15 },
          },
          {
            filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-sh.png",
            priority = "medium",
            width = 508,
            height = 446,
            frame_count = 1,
            scale = 0.5,
            shift = { 0.38, 0.22 },
            draw_as_shadow = true,
          },
        },
      },
      water_reflection = {
        pictures = {
          filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-reflection.png",
          priority = "extra-high",
          width = 46,
          height = 46,
          shift = util.by_pixel(0, 40),
          variation_count = 1,
          scale = 5,
        },
        rotate = false,
        orientation_to_variation = false,
      },
      working_visualisations = {
        {
          draw_as_light = true,
          animation = {
            filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-working-glow-light.png",
            priority = "high",
            width = 144,
            height = 110,
            frame_count = 30,
            line_length = 6,
            scale = 0.5,
            animation_speed = 0.75,
            shift = { 0, -0.23 },
          },
        },
        {
          draw_as_glow = true,
          blend_mode = "additive",
          synced_fadeout = true,
          animation = {
            filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-working-glow.png",
            priority = "high",
            width = 144,
            height = 110,
            frame_count = 30,
            line_length = 6,
            scale = 0.5,
            animation_speed = 0.75,
            shift = { 0, -0.23 },
          },
        },
        {
          animation = {
            layers = {
              {
                filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-working-light.png",
                priority = "high",
                width = 473,
                height = 489,
                frame_count = 30,
                line_length = 6,
                scale = 0.5,
                animation_speed = 0.75,
                shift = { 0, -0.15 },
                draw_as_light = true,
              },
              {
                filename = "__Krastorio2Assets__/buildings/matter-associator/matter-associator-working.png",
                priority = "high",
                width = 473,
                height = 489,
                frame_count = 30,
                line_length = 6,
                scale = 0.5,
                animation_speed = 0.75,
                shift = { 0, -0.15 },
              },
            },
          },
          light = {
            intensity = 0.80,
            size = 6,
            shift = { 0, -0.15 },
            color = { r = 0.35, g = 0.5, b = 1 },
          },
        },
      },
    },
    icon_draw_specification = { scale = 2, shift = { 0, -0.3 } },
    icons_positioning = { { inventory_index = defines.inventory.assembling_machine_modules, shift = { 0, 1.25 } } },

    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions.create_vector(universal_connector_template, {
      {
        variation = 2,
        main_offset = util.by_pixel(90, -105),
        shadow_offset = util.by_pixel(88, -105),
        show_shadow = false,
      },
      {
        variation = 2,
        main_offset = util.by_pixel(90, -105),
        shadow_offset = util.by_pixel(88, -105),
        show_shadow = false,
      },
      {
        variation = 2,
        main_offset = util.by_pixel(90, -105),
        shadow_offset = util.by_pixel(88, -105),
        show_shadow = false,
      },
      {
        variation = 2,
        main_offset = util.by_pixel(90, -105),
        shadow_offset = util.by_pixel(88, -105),
        show_shadow = false,
      },
    }),
  },
})
