local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

local picture = {
  layers = {
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-light.png",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 1,
      shift = { 0, -0.8 },
      draw_as_light = true,
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver.png",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 1,
      shift = { 0, -0.8 },
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-sh.png",
      width = 867,
      height = 626,
      scale = 0.5,
      frame_count = 1,
      draw_as_shadow = true,
      shift = { 0.52, 0.5 },
    },
  },
}

local animation = {
  layers = {
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver.png",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 1,
      repeat_count = 60,
      animation_speed = 0.3447,
      shift = { 0, -0.8 },
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-sh.png",
      priority = "low",
      width = 867,
      height = 626,
      scale = 0.5,
      frame_count = 1,
      repeat_count = 60,
      draw_as_shadow = true,
      animation_speed = 0.3447,
      shift = { 0.52, 0.5 },
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-charging.png",
      priority = "high",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 60,
      line_length = 10,
      animation_speed = 0.3447,
      shift = { 0, -0.8 },
      draw_as_glow = true,
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-light.png",
      priority = "high",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 1,
      repeat_count = 60,
      animation_speed = 0.3447,
      shift = { 0, -0.8 },
      draw_as_light = true,
    },
    {
      filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-charging-light.png",
      priority = "high",
      width = 800,
      height = 800,
      scale = 0.5,
      frame_count = 60,
      line_length = 10,
      animation_speed = 0.3447,
      shift = { 0, -0.8 },
      draw_as_light = true,
    },
  },
}

local working_sound = {
  sound = {
    variations = {
      {
        filename = "__Krastorio2Assets__/sounds/buildings/intergalactic-transceiver-charge.ogg",
        volume = 1,
      },
      {
        filename = "__Krastorio2Assets__/sounds/buildings/intergalactic-transceiver-charge.ogg",
        volume = 1,
      },
      {
        filename = "__Krastorio2Assets__/sounds/buildings/intergalactic-transceiver-charge-morse.ogg",
        volume = 1,
      },
    },
  },
  idle_sound = {
    filename = "__Krastorio2Assets__/sounds/buildings/intergalactic-transceiver.ogg",
    volume = 1,
  },
  max_sounds_per_prototype = 3,
  fade_in_ticks = 10,
  fade_out_ticks = 30,
}

data:extend({
  {
    type = "recipe",
    name = "kr-intergalactic-transceiver",
    energy_required = 600,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-imersium-beam", amount = 500 },
      { type = "item", name = "kr-imersium-plate", amount = 500 },
      { type = "item", name = "kr-rare-metals", amount = 1000 },
      { type = "item", name = "kr-energy-control-unit", amount = 500 },
      { type = "item", name = "kr-ai-core", amount = 300 },
      { type = "item", name = "concrete", amount = 750 },
    },
    results = { { type = "item", name = "kr-intergalactic-transceiver", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-intergalactic-transceiver",
    icon = "__Krastorio2Assets__/icons/entities/intergalactic-transceiver.png",
    subgroup = "kr-radar",
    order = "zzzz[intergalactic-transceiver]",
    place_result = "kr-intergalactic-transceiver",
    stack_size = 1,
  },
  {
    type = "accumulator",
    name = "kr-intergalactic-transceiver",
    icon = "__Krastorio2Assets__/icons/entities/intergalactic-transceiver.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation", "not-rotatable" },
    map_color = { r = 0.37, g = 0.18, b = 0.47 },
    minable = { mining_time = 10, result = "kr-intergalactic-transceiver" },
    placeable_by = { item = "kr-intergalactic-transceiver", count = 1 },
    collision_box = { { -5.75, -5.25 }, { 5.75, 5.25 } },
    selection_box = { { -6, -5.5 }, { 6, 5.5 } },
    drawing_box_vertical_extension = 1.25,
    max_health = 20000,
    corpse = "kr-big-random-pipes-remnants",
    dying_explosion = "nuclear-reactor-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    resistances = {
      { type = "physical", percent = 75 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    energy_source = {
      type = "electric",
      buffer_capacity = "30TJ",
      usage_priority = "tertiary",
      input_flow_limit = "60GW",
      output_flow_limit = "0W",
    },
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = working_sound,
    default_output_signal = { type = "virtual", name = "signal-I" },
    chargable_graphics = {
      picture = picture,
      charge_animation = animation,
      charge_cooldown = 240,
      charge_light = {
        intensity = 0.75,
        size = 20,
        shift = { 0, -0.5 },
        color = { r = 1, g = 0.2, b = 1 },
      },
      discharge_animation = animation,
      discharge_cooldown = 240,
    },
  },
  {
    type = "electric-energy-interface",
    name = "kr-activated-intergalactic-transceiver",
    icon = "__Krastorio2Assets__/icons/entities/intergalactic-transceiver.png",
    flags = { "player-creation", "not-rotatable" },
    map_color = { r = 0.37, g = 0.18, b = 0.47 },
    minable = { mining_time = 10, result = "kr-intergalactic-transceiver" },
    placeable_by = { item = "kr-intergalactic-transceiver", count = 1 },
    collision_box = { { -5.75, -5.25 }, { 5.75, 5.25 } },
    selection_box = { { -6, -5.5 }, { 6, 5.5 } },
    drawing_box_vertical_extension = 1.25,
    max_health = 10000,
    corpse = "kr-big-random-pipes-remnants",
    dying_explosion = "nuclear-reactor-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    resistances = {
      { type = "physical", percent = 75 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    energy_source = {
      type = "electric",
      buffer_capacity = "10GJ",
      usage_priority = "primary-output",
      input_flow_limit = "10GW",
      output_flow_limit = "10GW",
      render_no_power_icon = false,
    },
    energy_production = "10GW",
    energy_usage = "0kW",
    working_sound = working_sound,
    continuous_animation = true,
    light = {
      intensity = 1.75,
      size = 30,
      shift = { 0, -0.5 },
      color = { r = 1, g = 0.2, b = 1 },
    },
    animation = {
      layers = {
        {
          filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver.png",
          width = 800,
          height = 800,
          scale = 0.5,
          frame_count = 1,
          repeat_count = 60,
          animation_speed = 0.3447,
          shift = { 0, -0.8 },
        },
        {
          filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-sh.png",
          priority = "low",
          width = 867,
          height = 626,
          scale = 0.5,
          frame_count = 1,
          repeat_count = 60,
          draw_as_shadow = true,
          animation_speed = 0.3447,
          shift = { 0.52, 0.5 },
        },
        {
          filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-charge.png",
          priority = "high",
          width = 800,
          height = 800,
          scale = 0.5,
          frame_count = 60,
          line_length = 10,
          animation_speed = 0.3447,
          shift = { 0, -0.8 },
          draw_as_glow = true,
        },
        {
          filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-light.png",
          priority = "high",
          width = 800,
          height = 800,
          scale = 0.5,
          frame_count = 1,
          repeat_count = 60,
          animation_speed = 0.3447,
          shift = { 0, -0.8 },
          draw_as_light = true,
        },
        {
          filename = "__Krastorio2Assets__/buildings/intergalactic-transceiver/intergalactic-transceiver-charge-light.png",
          priority = "high",
          width = 800,
          height = 800,
          scale = 0.5,
          frame_count = 60,
          line_length = 10,
          animation_speed = 0.3447,
          shift = { 0, -0.8 },
          draw_as_light = true,
        },
      },
    },
  },
  {
    type = "simple-entity-with-owner",
    name = "kr-inactive-intergalactic-transceiver",
    localised_name = { "entity-name.kr-intergalactic-transceiver" },
    localised_description = { "entity-description.kr-intergalactic-transceiver" },
    icon = "__Krastorio2Assets__/icons/entities/intergalactic-transceiver.png",
    flags = { "not-on-map" },
    hidden = true,
    minable = { mining_time = 10, result = "kr-intergalactic-transceiver" },
    placeable_by = { item = "kr-intergalactic-transceiver", count = 1 },
    collision_box = { { -5.75, -5.25 }, { 5.75, 5.25 } },
    selection_box = { { -6, -5.5 }, { 6, 5.5 } },
    drawing_box_vertical_extension = 1.25,
    resistances = {
      { type = "physical", percent = 75 },
      { type = "fire", percent = 75 },
      { type = "impact", percent = 75 },
    },
    picture = picture,
  },
})
