local hit_effects = require("__base__.prototypes.entity.hit-effects")
local sounds = require("__base__.prototypes.entity.sounds")

local pipe_pictures = {
  north = {
    filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-k-pipe-N.png",
    priority = "extra-high",
    width = 71,
    height = 38,
    shift = util.by_pixel(2.25, 13.5),
    scale = 0.5,
  },
  east = {
    filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-k-pipe-E.png",
    priority = "extra-high",
    width = 42,
    height = 76,
    shift = util.by_pixel(-24.5, 1),
    scale = 0.5,
  },
  south = {
    filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-k-pipe-S.png",
    priority = "extra-high",
    width = 88,
    height = 61,
    shift = util.by_pixel(0, -31.25),
    scale = 0.5,
  },
  west = {
    filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-k-pipe-W.png",
    priority = "extra-high",
    width = 39,
    height = 73,
    shift = util.by_pixel(25.75, 1.25),
    scale = 0.5,
  },
}

data:extend({
  {
    type = "recipe",
    name = "kr-advanced-assembling-machine",
    energy_required = 10,
    enabled = false,
    ingredients = {
      { type = "item", name = "kr-imersium-beam", amount = 4 },
      { type = "item", name = "assembling-machine-3", amount = 2 },
      { type = "item", name = "electric-furnace", amount = 2 },
      { type = "item", name = "kr-ai-core", amount = 2 },
    },
    results = { { type = "item", name = "kr-advanced-assembling-machine", amount = 1 } },
  },
  {
    type = "item",
    name = "kr-advanced-assembling-machine",
    icon = "__Krastorio2Assets__/icons/entities/advanced-assembling-machine.png",
    subgroup = "production-machine",
    order = "c2[advanced-assembling-machine]",
    place_result = "kr-advanced-assembling-machine",
    stack_size = 50,
  },
  {
    type = "assembling-machine",
    name = "kr-advanced-assembling-machine",
    icon = "__Krastorio2Assets__/icons/entities/advanced-assembling-machine.png",
    flags = { "placeable-neutral", "placeable-player", "player-creation" },
    minable = { mining_time = 1, result = "kr-advanced-assembling-machine" },
    collision_box = { { -2.25, -2.25 }, { 2.25, 2.25 } },
    selection_box = { { -2.5, -2.5 }, { 2.5, 2.5 } },
    crafting_categories = {
      "basic-crafting",
      "crafting",
      "advanced-crafting",
      "crafting-with-fluid",
      "kr-smelting-crafting",
    },
    crafting_speed = 5,
    module_slots = 4,
    allowed_effects = { "consumption", "speed", "productivity", "pollution" },
    fluid_boxes = {
      {
        production_type = "input",
        pipe_picture = pipe_pictures,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "input", direction = defines.direction.north, position = { 0, -2 } } },
        secondary_draw_orders = { north = -1 },
      },
      {
        production_type = "output",
        pipe_picture = pipe_pictures,
        pipe_covers = pipecoverspictures(),
        volume = 1000,
        pipe_connections = { { flow_direction = "output", direction = defines.direction.south, position = { 0, 2 } } },
        secondary_draw_orders = { south = -1 },
      },
    },
    fluid_boxes_off_when_no_fluid_recipe = true,
    energy_source = {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = { pollution = 5 },
    },
    energy_usage = "0.925MW",
    max_health = 800,
    corpse = "kr-medium-random-pipes-remnants",
    dying_explosion = "big-explosion",
    damaged_trigger_effect = hit_effects.entity(),
    resistances = {
      { type = "physical", percent = 50 },
      { type = "fire", percent = 95 },
      { type = "impact", percent = 80 },
    },
    open_sound = sounds.machine_open,
    close_sound = sounds.machine_close,
    idle_sound = { filename = "__base__/sound/idle1.ogg" },
    vehicle_impact_sound = sounds.generic_impact,
    working_sound = {
      sound = {
        {
          filename = "__Krastorio2Assets__/sounds/buildings/advanced-assembling-machine.ogg",
          volume = 0.5,
        },
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.3 },
      max_sounds_per_prototype = 3,
      fade_in_ticks = 10,
      fade_out_ticks = 30,
    },
    graphics_set = {
      animation = {
        layers = {
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine.png",
            priority = "high",
            width = 320,
            height = 320,
            frame_count = 1,
            repeat_count = 32,
            animation_speed = 0.25,
            shift = { 0, 0 },
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-w1.png",
            priority = "high",
            width = 128,
            height = 144,
            shift = { -1.02, 0.29 },
            frame_count = 32,
            line_length = 8,
            animation_speed = 0.1,
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-steam.png",
            priority = "high",
            width = 80,
            height = 81,
            shift = { -1.2, -2.1 },
            frame_count = 32,
            line_length = 8,
            animation_speed = 1.5,
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-sh.png",
            priority = "high",
            width = 346,
            height = 302,
            shift = { 0.32, 0.12 },
            frame_count = 1,
            repeat_count = 32,
            animation_speed = 0.1,
            draw_as_shadow = true,
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-w2.png",
            priority = "high",
            width = 37,
            height = 25,
            frame_count = 8,
            line_length = 4,
            repeat_count = 4,
            animation_speed = 0.1,
            shift = { 0.17, -1.445 },
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-w3.png",
            priority = "high",
            width = 23,
            height = 15,
            frame_count = 8,
            line_length = 4,
            repeat_count = 4,
            animation_speed = 0.1,
            shift = { 0.93, -2.05 },
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-w3.png",
            priority = "high",
            width = 23,
            height = 15,
            frame_count = 8,
            line_length = 4,
            repeat_count = 4,
            animation_speed = 0.1,
            shift = { 0.868, -0.082 },
            scale = 0.5,
          },
          {
            filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-w3.png",
            priority = "high",
            width = 23,
            height = 15,
            frame_count = 8,
            line_length = 4,
            repeat_count = 4,
            animation_speed = 0.1,
            shift = { 0.868, 0.552 },
            scale = 0.5,
          },
        },
      },
      water_reflection = {
        pictures = {
          filename = "__Krastorio2Assets__/buildings/advanced-assembling-machine/advanced-assembling-machine-reflection.png",
          priority = "extra-high",
          width = 70,
          height = 50,
          shift = util.by_pixel(0, 40),
          variation_count = 1,
          scale = 5,
        },
        rotate = false,
        orientation_to_variation = false,
      },
    },
    icon_draw_specification = { scale = 2, shift = { 0, -0.3 } },
    icons_positioning = { { inventory_index = defines.inventory.assembling_machine_modules, shift = { 0, 1.25 } } },

    circuit_wire_max_distance = default_circuit_wire_max_distance,
    circuit_connector = circuit_connector_definitions.create_vector(universal_connector_template, {
      {
        variation = 0,
        main_offset = util.by_pixel_hr(104, -96),
        shadow_offset = util.by_pixel_hr(104, -96),
        show_shadow = false,
      },
      {
        variation = 0,
        main_offset = util.by_pixel_hr(104, -96),
        shadow_offset = util.by_pixel_hr(104, -96),
        show_shadow = false,
      },
      {
        variation = 0,
        main_offset = util.by_pixel_hr(104, -96),
        shadow_offset = util.by_pixel_hr(104, -96),
        show_shadow = false,
      },
      {
        variation = 0,
        main_offset = util.by_pixel_hr(104, -96),
        shadow_offset = util.by_pixel_hr(104, -96),
        show_shadow = false,
      },
    }),
  },
})
